package com.elitescloud.boot.webservice.support;

import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceProvider;
import com.elitescloud.boot.webservice.WebServiceProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * 服务提供端配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
@Log4j2
public abstract class AbstractServiceProviderConfig implements ServiceProviderConfig, ApplicationRunner {

    protected WebServiceProperties properties;
    protected ApplicationContext applicationContext;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        var beans = applicationContext.getBeansWithAnnotation(WebServiceProvider.class);
        if (beans.isEmpty()) {
            log.info("未找到有效的WebService服务提供者");
        }
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            WebServiceProvider provider = entry.getValue().getClass().getAnnotation(WebServiceProvider.class);
            Assert.hasText(provider.path(), entry.getKey() + "的address未配置");
            Assert.isTrue(provider.path().startsWith("/"), entry.getKey() + "的address需要以/开头");

            publishService(entry.getValue(), entry.getKey(), provider);

            log.info("发布接口{} -> {}", entry.getKey(), provider.path());
        }
    }

    @Autowired
    public void setProperties(WebServiceProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}
