package com.elitescloud.boot.webservice.support.cxf;

import com.elitescloud.boot.webservice.WebServiceProperties;
import org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Import;

/**
 * cxf相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@ConditionalOnProperty(prefix = WebServiceProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true")
@ConditionalOnClass(CxfAutoConfiguration.class)
@Import({CxfServiceProviderConfig.class, CxfServiceConsumerConfig.class})
@AutoConfigureBefore(name = {
        "org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration"
})
public class CloudtCxfAutoConfiguration {
}
