/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.webservice;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.support.LogStartedInfo;
import com.elitescloud.boot.webservice.WebServiceProperties;
import com.elitescloud.boot.webservice.support.ServiceProviderConfig;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import javax.ws.rs.BadRequestException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={WebServiceProperties.class})
public class WebServiceAutoConfiguration {
    private static final Logger log = LogManager.getLogger(WebServiceAutoConfiguration.class);

    public WebServiceAutoConfiguration() {
        log.info("\u542f\u7528WebService");
    }

    @Bean
    public LogStartedInfo logStartedInfoWebService(final ServiceProviderConfig provider) {
        return new LogStartedInfo(){

            public void print(String uriPrefix) {
                String webserviceApiUri = this.generateWebServiceUri(uriPrefix);
                if (StringUtils.hasText((String)webserviceApiUri)) {
                    log.info("\u53ef\u8bbf\u95eeWebService API\uff1a{}", (Object)webserviceApiUri);
                }
            }

            private String generateWebServiceUri(String uriPrefix) {
                if (provider != null) {
                    WebServiceProperties webServiceProperties = (WebServiceProperties)SpringContextHolder.getBean(WebServiceProperties.class);
                    return (uriPrefix.endsWith("/") ? uriPrefix.substring(0, uriPrefix.length() - 1) : uriPrefix) + webServiceProperties.getServicePath();
                }
                return null;
            }
        };
    }

    @Bean
    public CustomExceptionTranslate exceptionTranslateWebService() {
        return new CustomExceptionTranslate(){

            public boolean support(@NonNull Throwable e) {
                return e instanceof BadRequestException;
            }

            public ApiResult<String> translate(@NonNull Throwable e) {
                return ApiResult.fail((ApiCode)ApiCode.BAD_REQUEST, (String)"WebService\u8bf7\u6c42\u5f02\u5e38");
            }
        };
    }
}

