package com.elitescloud.boot.webservice;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.util.List;
import java.util.Set;

/**
 * WebService相关配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
@ConfigurationProperties(prefix = WebServiceProperties.CONFIG_PREFIX)
@Validated
public class WebServiceProperties {
    public static final String CONFIG_PREFIX = "elitesland.webservice";

    /**
     * 是否启用WebService
     */
    private Boolean enabled = false;

    /**
     * Servlet 路径
     */
    @NotBlank
    @Pattern(regexp = "/[^?#]*", message = "路径必须以/开始")
    private String servicePath = "/services";

    /**
     * 消费端地址
     */
    @Valid
    private List<ConsumerAddress> consumerAddresses;

    /**
     * 消费者包路径
     */
    private Set<String> consumerPackages;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getServicePath() {
        return servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public List<ConsumerAddress> getConsumerAddresses() {
        return consumerAddresses;
    }

    public void setConsumerAddresses(List<ConsumerAddress> consumerAddresses) {
        this.consumerAddresses = consumerAddresses;
    }

    public Set<String> getConsumerPackages() {
        return consumerPackages;
    }

    public void setConsumerPackages(Set<String> consumerPackages) {
        this.consumerPackages = consumerPackages;
    }

    public static class ConsumerAddress {

        /**
         * 地址key
         */
        @NotBlank
        private String addressKey;

        /**
         * 地址
         */
        @NotBlank
        private String address;

        public String getAddressKey() {
            return addressKey;
        }

        public void setAddressKey(String addressKey) {
            this.addressKey = addressKey;
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }
}
