/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.webservice.support.cxf;

import com.elitescloud.boot.webservice.support.AbstractServiceProviderConfig;
import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceProvider;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={SpringBus.class})
public class CxfServiceProviderConfig
extends AbstractServiceProviderConfig {
    private final CxfProperties cxfProperties;
    private final SpringBus springBus;

    public CxfServiceProviderConfig(CxfProperties cxfProperties, SpringBus springBus) {
        this.cxfProperties = cxfProperties;
        this.springBus = springBus;
    }

    @Bean(value={"cxfServletRegistration"})
    public ServletRegistrationBean<CXFServlet> cxfServletRegistration() {
        String path = this.properties.getServicePath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new CXFServlet(), new String[]{urlMapping});
        CxfProperties.Servlet servletProperties = this.cxfProperties.getServlet();
        registration.setLoadOnStartup(servletProperties.getLoadOnStartup());
        for (Map.Entry entry : servletProperties.getInit().entrySet()) {
            registration.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return registration;
    }

    @Override
    public void publishService(Object bean, String beanName, WebServiceProvider webServiceProvider) {
        EndpointImpl endpoint = new EndpointImpl((Bus)this.springBus, bean);
        endpoint.publish(webServiceProvider.path());
    }
}

