/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.support;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManager {
    private static final ConcurrentHashMap<String, List<WebSocketSession>> USER_SESSION_ALL = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WebSocketSessionWrapper> SESSION_ALL = new ConcurrentHashMap();

    public static List<WebSocketSession> getWebSocketSession(@NotBlank String username) {
        return USER_SESSION_ALL.getOrDefault(username, Collections.emptyList());
    }

    static void addSession(@NotNull WebSocketSession session) {
        WebSocketSessionManager.addAuthSession(session, null);
    }

    static void addAuthSession(@NotNull WebSocketSession session, GeneralUserDetails userDetails) {
        SESSION_ALL.put(session.getId(), new WebSocketSessionWrapper(session, userDetails));
        if (userDetails != null) {
            USER_SESSION_ALL.computeIfAbsent(userDetails.getUsername(), t -> new ArrayList()).add(session);
        }
    }

    static void addTenantSession(@NotNull WebSocketSession session, SysTenantDTO tenantDTO) {
        SESSION_ALL.put(session.getId(), new WebSocketSessionWrapper(session, tenantDTO));
    }

    static GeneralUserDetails obtainAuthUser(@NotNull WebSocketSession session) {
        WebSocketSessionWrapper wrapperSession = SESSION_ALL.get(session.getId());
        return wrapperSession == null ? null : wrapperSession.getCurrentUser();
    }

    public static void removeSession(@NotNull WebSocketSession session) {
        WebSocketSessionWrapper sessionWrapper = SESSION_ALL.get(session.getId());
        if (sessionWrapper == null) {
            return;
        }
        SESSION_ALL.remove(session.getId());
        if (sessionWrapper.getCurrentUser() != null) {
            ArrayList<WebSocketSession> sessions = new ArrayList<WebSocketSession>();
            for (WebSocketSession webSocketSession : USER_SESSION_ALL.get(sessionWrapper.getCurrentUser().getUsername())) {
                if (Objects.equals(session.getId(), webSocketSession.getId())) continue;
                sessions.add(webSocketSession);
            }
            USER_SESSION_ALL.put(sessionWrapper.getCurrentUser().getUsername(), sessions);
        }
        try {
            session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class WebSocketSessionWrapper {
        private final WebSocketSession webSocketSession;
        private final GeneralUserDetails currentUser;
        private final SysTenantDTO tenantDTO;

        public WebSocketSessionWrapper(@NotNull WebSocketSession webSocketSession) {
            this.webSocketSession = webSocketSession;
            this.currentUser = null;
            this.tenantDTO = null;
        }

        public WebSocketSessionWrapper(@NotNull WebSocketSession webSocketSession, GeneralUserDetails currentUser) {
            this.webSocketSession = webSocketSession;
            this.currentUser = currentUser;
            this.tenantDTO = null;
        }

        public WebSocketSessionWrapper(WebSocketSession webSocketSession, SysTenantDTO tenantDTO) {
            this.webSocketSession = webSocketSession;
            this.currentUser = null;
            this.tenantDTO = tenantDTO;
        }

        public WebSocketSession getWebSocketSession() {
            return this.webSocketSession;
        }

        public GeneralUserDetails getCurrentUser() {
            return this.currentUser;
        }

        public SysTenantDTO getTenantDTO() {
            if (this.currentUser != null && this.currentUser.getTenant() != null) {
                return this.currentUser.getTenant();
            }
            return this.tenantDTO;
        }
    }
}

