package com.elitescloud.boot.websocket.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

import java.time.Duration;

/**
 * WebSocket属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/30
 */
@ConfigurationProperties(prefix = CloudtWebSocketProperties.CONFIG_PREFIX)
public class CloudtWebSocketProperties {
    public static final String CONFIG_PREFIX = "elitesland.websocket";

    /**
     * 最大的文本大小，默认8KB
     */
    private DataSize maxTextMessageBufferSize = DataSize.ofKilobytes(8);

    /**
     * 最大的字节大小，默认8MB
     */
    private DataSize maxBinaryMessageBufferSize = DataSize.ofMegabytes(8);

    /**
     * session最大空闲时间，0或负数时永不超时
     */
    private Duration maxSessionIdleTimeout;

    /**
     * 异步发送超时时间，非正数表示不超时
     */
    private Duration asyncSendTimeout;

    public DataSize getMaxTextMessageBufferSize() {
        return maxTextMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(DataSize maxTextMessageBufferSize) {
        this.maxTextMessageBufferSize = maxTextMessageBufferSize;
    }

    public DataSize getMaxBinaryMessageBufferSize() {
        return maxBinaryMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(DataSize maxBinaryMessageBufferSize) {
        this.maxBinaryMessageBufferSize = maxBinaryMessageBufferSize;
    }

    public Duration getMaxSessionIdleTimeout() {
        return maxSessionIdleTimeout;
    }

    public void setMaxSessionIdleTimeout(Duration maxSessionIdleTimeout) {
        this.maxSessionIdleTimeout = maxSessionIdleTimeout;
    }

    public Duration getAsyncSendTimeout() {
        return asyncSendTimeout;
    }

    public void setAsyncSendTimeout(Duration asyncSendTimeout) {
        this.asyncSendTimeout = asyncSendTimeout;
    }
}
