package com.elitescloud.boot.websocket.support.redis;

import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitescloud.boot.websocket.support.WebSocketSessionManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

import java.io.IOException;
import java.io.Serializable;

/**
 * 基于redis的消息发布和订阅.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/2
 */
@Slf4j
public class WebSocketRedisMessageSubscribe implements RedisMessageSubscribe {

    @Override
    public String[] channel() {
        return new String[]{WebSocketRedisConstant.CHANNEL};
    }

    @Override
    public <T extends Serializable> void onMessage(T message, String channel) {
        if (!(message instanceof RedisWebSocketMsg)) {
            log.error("接收到{}的消息{}, 不属于WebSocket消息", channel, message.getClass().getName());
            return;
        }

        RedisWebSocketMsg msg = (RedisWebSocketMsg) message;
        var textMessage = new TextMessage(msg.getMsg());
        for (String account : msg.getAccount()) {
            // 获取用户的所有session，逐个发送
            var sessionList = WebSocketSessionManager.getSession(account);
            for (WebSocketSession session : sessionList) {
                if (!session.isOpen()) {
                    // session已关闭
                    WebSocketSessionManager.removeSession(session);
                    continue;
                }

                try {
                    session.sendMessage(textMessage);
                } catch (IOException e) {
                    log.error("发送消息[{}]异常：", msg, e);
                }
            }
        }
    }
}
