package com.elitescloud.boot.websocket;

import com.elitescloud.boot.websocket.model.BaseParameterType;
import com.elitescloud.cloudt.common.base.ApiResult;

import javax.annotation.Nullable;
import java.io.Serializable;

/**
 * 云梯WebSocketHandler.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/30
 */
public interface CloudtWebSocketHandler<T extends BaseParameterType, R extends Serializable> {

    /**
     * 处理的路径
     *
     * @return 路径数组
     */
    String[] paths();

    /**
     * 参数类型
     *
     * @return 参数类型
     */
    Class<T> parameterType();

    /**
     * 消息处理
     * <p>
     * 如果return结构为空，则不返回内容
     *
     * @param payload 消息体
     * @return 处理结果
     */
    @Nullable
    ApiResult<R> handle(@Nullable T payload);

    /**
     * 允许的跨域
     *
     * @return 跨域
     */
    default String[] allowedOrigins() {
        return new String[]{"*"};
    }

    /**
     * 允许的跨域
     *
     * @return 跨域
     */
    default String[] allowedOriginPatterns() {
        return new String[0];
    }
}
