/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.CommonAuthenticationToken;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.boot.websocket.CloudtWebSocketHandler;
import com.elitescloud.boot.websocket.common.MsgType;
import com.elitescloud.boot.websocket.model.BaseParameterType;
import com.elitescloud.boot.websocket.support.WebSocketSessionManager;
import com.elitescloud.boot.websocket.util.WebSocketUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class CloudtWebSocketHandlerDelegate<T extends BaseParameterType, R extends Serializable>
extends AbstractWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(CloudtWebSocketHandlerDelegate.class);
    private final CloudtWebSocketHandler<T, R> delegate;
    private final UserDetailProvider userDetailProvider;
    private final Class<T> parameterType;
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();

    public CloudtWebSocketHandlerDelegate(CloudtWebSocketHandler<T, R> delegate, UserDetailProvider userDetailProvider) {
        this.delegate = delegate;
        this.userDetailProvider = userDetailProvider;
        this.parameterType = delegate.parameterType();
        Assert.notNull(this.parameterType, () -> "\u83b7\u53d6" + delegate.getClass().getName() + "\u53c2\u6570\u7c7b\u578b\u5931\u8d25");
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
        if (session.getAttributes().containsKey("cloudt_user_deatil")) {
            WebSocketSessionManager.addAuthSession(session, (GeneralUserDetails)session.getAttributes().get("cloudt_user_deatil"));
        }
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) throws Exception {
        String msg = (String)message.getPayload();
        if (CharSequenceUtil.isBlank((CharSequence)msg)) {
            log.info("\u6d88\u606f\u4e3a\u7a7a\uff0c\u5ffd\u7565\uff01");
            return;
        }
        log.debug("WebSocket Msg:{}", (Object)msg);
        Map payload = null;
        try {
            payload = (Map)this.objectMapper.readValue((String)message.getPayload(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(false, "\u6d88\u606f\u683c\u5f0f\u4e0d\u6b63\u786e", null));
            return;
        }
        Object payloadType = payload.get("type");
        if (!(payloadType instanceof String)) {
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(false, "\u7f3a\u5c11\u5b57\u7b26\u4e32\u53c2\u6570type", null));
            return;
        }
        String type = (String)payloadType;
        boolean dealed = this.attemptAuth(session, type, payload);
        if (dealed) {
            return;
        }
        this.adapterToHandler(session, payload);
    }

    protected void handleBinaryMessage(@NonNull WebSocketSession session, @NonNull BinaryMessage message) throws Exception {
        log.warn("\u6682\u4e0d\u652f\u6301binary message");
        try {
            session.close(CloseStatus.NOT_ACCEPTABLE.withReason("Binary messages not supported"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleTransportError(@NonNull WebSocketSession session, @NonNull Throwable exception) throws Exception {
        log.error("WebSocket \u901a\u8baf\u5f02\u5e38\uff1a", exception);
        WebSocketSessionManager.removeSession(session);
        super.handleTransportError(session, exception);
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) throws Exception {
        super.afterConnectionClosed(session, status);
        WebSocketSessionManager.removeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adapterToHandler(WebSocketSession session, Map<String, Object> payload) throws IOException {
        BaseParameterType parameter = null;
        try {
            parameter = (BaseParameterType)this.objectMapper.convertValue(payload, this.parameterType);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(false, "\u6d88\u606f\u683c\u5f0f\u4e0d\u6b63\u786e", null));
            return;
        }
        GeneralUserDetails userDetail = WebSocketSessionManager.obtainAuthUser(session);
        if (userDetail != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new CommonAuthenticationToken(SecurityContextHolder.getContext().getAuthentication(), userDetail, Collections.emptyList()));
        }
        ApiResult apiResult = null;
        try {
            apiResult = this.delegate.handle(parameter);
        }
        catch (Throwable e) {
            log.error("\u5904\u7406\u6d88\u606f\u5f02\u5e38\uff1a", e);
            apiResult = ApiResult.fail((String)("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        finally {
            if (userDetail != null) {
                SecurityContextHolder.clearContext();
            }
        }
        if (apiResult != null) {
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(apiResult));
        }
    }

    private boolean attemptAuth(WebSocketSession session, String type, Map<String, Object> payload) throws IOException {
        if (!MsgType.AUTH.name().equals(type)) {
            return false;
        }
        Object accessToken = payload.get("accessToken");
        if (!(accessToken instanceof String) || CharSequenceUtil.isBlank((CharSequence)accessToken.toString())) {
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(false, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570accessToken", null));
            return true;
        }
        String token = accessToken.toString();
        GeneralUserDetails user = this.userDetailProvider.getByToken(token);
        log.debug("WebSocket Authorized User\uff1a{}", (Object)(user == null ? null : user.getUsername()));
        if (user == null) {
            session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(false, "\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", null));
            return true;
        }
        WebSocketSessionManager.addAuthSession(session, user);
        session.sendMessage((WebSocketMessage)WebSocketUtil.convertTextMessage(true, "\u8ba4\u8bc1\u6210\u529f", null));
        return true;
    }
}

