/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.support;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManager {
    private static final ConcurrentHashMap<String, List<WebSocketSession>> USER_SESSION_ALL = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WebSocketSessionWrapper> SESSION_ALL = new ConcurrentHashMap();

    public static List<WebSocketSession> getSession(@NotBlank String username) {
        return USER_SESSION_ALL.getOrDefault(username, Collections.emptyList());
    }

    public static int countSession() {
        return SESSION_ALL.size();
    }

    public static List<String> onlineUsers() {
        Enumeration<String> usernameEnumeration = SESSION_ALL.keys();
        ArrayList<String> usernameList = new ArrayList<String>();
        while (usernameEnumeration.hasMoreElements()) {
            usernameList.add(usernameEnumeration.nextElement());
        }
        return usernameList;
    }

    public static List<SessionUser> sessionOfUser(@NotBlank String username) {
        return USER_SESSION_ALL.getOrDefault(username, Collections.emptyList()).stream().filter(t -> SESSION_ALL.containsKey(t.getId())).map(t -> {
            WebSocketSessionWrapper session = SESSION_ALL.get(t.getId());
            SessionUser sessionUser = new SessionUser();
            sessionUser.setUsername(session.currentUser.getUsername());
            sessionUser.setUserId(session.currentUser.getUserId());
            sessionUser.setCreateTime(session.createTime);
            sessionUser.setSessionId(t.getId());
            if (session.tenantDTO != null) {
                sessionUser.setTenantCode(session.tenantDTO.getTenantCode());
            }
            return sessionUser;
        }).collect(Collectors.toList());
    }

    static void addSession(@NotNull WebSocketSession session) {
        WebSocketSessionManager.addAuthSession(session, null);
    }

    static void addAuthSession(@NotNull WebSocketSession session, GeneralUserDetails userDetails) {
        SESSION_ALL.put(session.getId(), new WebSocketSessionWrapper(session, userDetails));
        if (userDetails != null) {
            USER_SESSION_ALL.computeIfAbsent(userDetails.getUsername(), t -> new ArrayList()).add(session);
        }
    }

    static void addTenantSession(@NotNull WebSocketSession session, SysTenantDTO tenantDTO) {
        SESSION_ALL.put(session.getId(), new WebSocketSessionWrapper(session, tenantDTO));
    }

    static GeneralUserDetails obtainAuthUser(@NotNull WebSocketSession session) {
        WebSocketSessionWrapper wrapperSession = SESSION_ALL.get(session.getId());
        return wrapperSession == null ? null : wrapperSession.getCurrentUser();
    }

    public static void removeSession(@NotNull WebSocketSession session) {
        WebSocketSessionWrapper sessionWrapper = SESSION_ALL.get(session.getId());
        if (sessionWrapper == null) {
            return;
        }
        SESSION_ALL.remove(session.getId());
        if (sessionWrapper.getCurrentUser() != null) {
            ArrayList<WebSocketSession> sessions = new ArrayList<WebSocketSession>();
            for (WebSocketSession webSocketSession : USER_SESSION_ALL.get(sessionWrapper.getCurrentUser().getUsername())) {
                if (Objects.equals(session.getId(), webSocketSession.getId())) continue;
                sessions.add(webSocketSession);
            }
            USER_SESSION_ALL.put(sessionWrapper.getCurrentUser().getUsername(), sessions);
        }
        try {
            session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class WebSocketSessionWrapper {
        private final WebSocketSession webSocketSession;
        private final GeneralUserDetails currentUser;
        private final SysTenantDTO tenantDTO;
        private final LocalDateTime createTime;

        public WebSocketSessionWrapper(@NotNull WebSocketSession webSocketSession) {
            this.webSocketSession = webSocketSession;
            this.currentUser = null;
            this.tenantDTO = null;
            this.createTime = LocalDateTime.now();
        }

        public WebSocketSessionWrapper(@NotNull WebSocketSession webSocketSession, GeneralUserDetails currentUser) {
            this.webSocketSession = webSocketSession;
            this.currentUser = currentUser;
            this.tenantDTO = null;
            this.createTime = LocalDateTime.now();
        }

        public WebSocketSessionWrapper(WebSocketSession webSocketSession, SysTenantDTO tenantDTO) {
            this.webSocketSession = webSocketSession;
            this.currentUser = null;
            this.tenantDTO = tenantDTO;
            this.createTime = LocalDateTime.now();
        }

        public WebSocketSession getWebSocketSession() {
            return this.webSocketSession;
        }

        public GeneralUserDetails getCurrentUser() {
            return this.currentUser;
        }

        public SysTenantDTO getTenantDTO() {
            if (this.currentUser != null && this.currentUser.getTenant() != null) {
                return this.currentUser.getTenant();
            }
            return this.tenantDTO;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }
    }

    public static class SessionUser
    implements Serializable {
        private static final long serialVersionUID = -1969237509857337862L;
        private String username;
        private Long userId;
        private String tenantCode;
        private LocalDateTime createTime;
        private String sessionId;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(LocalDateTime createTime) {
            this.createTime = createTime;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getTenantCode() {
            return this.tenantCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }
    }
}

