/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.util;

import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.boot.websocket.model.WebSocketResult;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.TextMessage;

public class WebSocketUtil {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUtil.class);

    private WebSocketUtil() {
    }

    public static <T extends Serializable> TextMessage convertTextMessage(boolean success, String msg, T data) {
        msg = StringUtils.hasText((String)msg) ? msg : (success ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25");
        WebSocketResult result = new WebSocketResult();
        result.setSuccess(success);
        result.setMsg(msg);
        result.setData(data);
        return WebSocketUtil.convertTextMessage(result);
    }

    public static <T extends Serializable> TextMessage convertTextMessage(@NotNull ApiResult<T> apiResult) {
        String msg = StringUtils.hasText((String)apiResult.getMsg()) ? apiResult.getMsg() : (apiResult.isSuccess() ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25");
        WebSocketResult result = new WebSocketResult();
        result.setSuccess(apiResult.isSuccess());
        result.setMsg(msg);
        result.setData((Serializable)apiResult.getData());
        return WebSocketUtil.convertTextMessage(result);
    }

    public static <T extends Serializable> TextMessage convertTextMessage(@NotNull WebSocketResult<T> result) {
        try {
            return new TextMessage((CharSequence)OBJECT_MAPPER.writeValueAsString(result));
        }
        catch (JsonProcessingException e) {
            LOG.error("\u8f6c\u6362\u6d88\u606f\u5f02\u5e38:", (Throwable)e);
            return new TextMessage((CharSequence)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

