package com.elitescloud.boot.websocket.common;

import com.elitescloud.boot.websocket.CloudtWebSocketHandler;
import com.elitescloud.boot.websocket.model.BaseParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;

/**
 * 处理器的父类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/30
 */
public abstract class AbstractCloudtWebSocketHandler<T extends BaseParameterType, R extends Serializable> implements CloudtWebSocketHandler<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCloudtWebSocketHandler.class);

    @SuppressWarnings("unchecked")
    @Override
    public Class<T> parameterType() {
        var superType = getClass().getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            var typeArguments = ((ParameterizedType) superType).getActualTypeArguments();
            if (typeArguments.length > 0) {
                return (Class<T>) typeArguments[0];
            }
        }
        LOG.error("获取参数类型失败：{}", getClass().getName());
        return null;
    }
}
