/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.support.redis;

import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitescloud.boot.websocket.support.WebSocketSessionManager;
import com.elitescloud.boot.websocket.support.redis.RedisWebSocketMsg;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketRedisMessageSubscribe
implements RedisMessageSubscribe {
    private static final Logger log = LoggerFactory.getLogger(WebSocketRedisMessageSubscribe.class);

    public String[] channel() {
        return new String[]{"cloudt_websocket"};
    }

    public <T extends Serializable> void onMessage(T message, String channel) {
        if (!(message instanceof RedisWebSocketMsg)) {
            log.error("\u63a5\u6536\u5230{}\u7684\u6d88\u606f{}, \u4e0d\u5c5e\u4e8eWebSocket\u6d88\u606f", (Object)channel, (Object)message.getClass().getName());
            return;
        }
        RedisWebSocketMsg msg = (RedisWebSocketMsg)message;
        TextMessage textMessage = new TextMessage((CharSequence)msg.getMsg());
        for (String account : msg.getAccount()) {
            List<WebSocketSession> sessionList = WebSocketSessionManager.getSession(account);
            for (WebSocketSession session : sessionList) {
                if (!session.isOpen()) {
                    WebSocketSessionManager.removeSession(session);
                    continue;
                }
                try {
                    session.sendMessage((WebSocketMessage)textMessage);
                }
                catch (IOException e) {
                    log.error("\u53d1\u9001\u6d88\u606f[{}]\u5f02\u5e38\uff1a", (Object)msg, (Object)e);
                }
            }
        }
    }
}

