/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.websocket.handler.WebSocketMsgPublishable;
import com.elitescloud.boot.websocket.support.WebSocketSessionManager;
import com.elitescloud.boot.websocket.util.WebSocketUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class CloudtWebSocketTemplate {
    private static final Logger log = LoggerFactory.getLogger(CloudtWebSocketTemplate.class);
    private final WebSocketMsgPublishable msgPublishable;

    public CloudtWebSocketTemplate(WebSocketMsgPublishable msgPublishable) {
        this.msgPublishable = msgPublishable;
    }

    public <T extends Serializable> void sendMsg(@NotNull ApiResult<T> message, String ... usernames) {
        TextMessage msg = WebSocketUtil.convertTextMessage(message);
        for (String username : usernames) {
            List<WebSocketSession> session = WebSocketSessionManager.getSession(username);
            if (CollUtil.isNotEmpty(session)) {
                this.executeSendMsg((WebSocketMessage<?>)msg, username, session);
                continue;
            }
            if (this.msgPublishable == null) continue;
            this.msgPublishable.publish((String)msg.getPayload(), username);
        }
    }

    public <T extends Serializable> void sendMsg(@NotNull byte[] message, String ... usernames) {
        BinaryMessage msg = WebSocketUtil.convertBinaryMessage(message);
        for (String username : usernames) {
            List<WebSocketSession> session = WebSocketSessionManager.getSession(username);
            if (CollUtil.isNotEmpty(session)) {
                this.executeSendMsg((WebSocketMessage<?>)msg, username, session);
                continue;
            }
            if (this.msgPublishable == null) continue;
            this.msgPublishable.publish(message, username);
        }
    }

    private void executeSendMsg(WebSocketMessage<?> msg, String username, List<WebSocketSession> sessions) {
        boolean sent = false;
        for (WebSocketSession session : sessions) {
            if (!session.isOpen()) {
                WebSocketSessionManager.removeSession(session);
                continue;
            }
            try {
                session.sendMessage(msg);
                sent = true;
            }
            catch (IOException e) {
                log.error("\u53d1\u9001\u6d88\u606f[{}]\u5f02\u5e38\uff1a", msg, (Object)e);
            }
        }
        if (!sent && this.msgPublishable != null) {
            if (msg instanceof TextMessage) {
                this.msgPublishable.publish((String)((TextMessage)msg).getPayload(), username);
            } else if (msg instanceof BinaryMessage) {
                this.msgPublishable.publish(((ByteBuffer)((BinaryMessage)msg).getPayload()).array(), username);
            }
        }
    }
}

