/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.xxljob;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.xxljob.JobTrace;
import com.elitescloud.boot.xxljob.TenantJobAspect;
import com.elitescloud.boot.xxljob.XxlJobProperties;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(prefix="elitesland.xxl-job", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={XxlJobSpringExecutor.class})
@EnableConfigurationProperties(value={XxlJobProperties.class})
public class CloudtXxlJobAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtXxlJobAutoConfiguration.class);
    @Value(value="${spring.application.name:unknown}")
    protected String applicationName;
    private final XxlJobProperties jobProperties;

    public CloudtXxlJobAutoConfiguration(XxlJobProperties jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info(">>>>>>>>>>> xxl-job config init.");
        Assert.state((boolean)StringUtils.hasText((String)this.jobProperties.getAdminAddress()), (String)"xxl-job\u7684admin-address\u4e3a\u7a7a");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.jobProperties.getAdminAddress());
        xxlJobSpringExecutor.setAppname(StrUtil.blankToDefault((CharSequence)this.jobProperties.getAppname(), (String)this.applicationName));
        xxlJobSpringExecutor.setAddress(this.jobProperties.getAddress());
        xxlJobSpringExecutor.setIp(this.jobProperties.getIp());
        xxlJobSpringExecutor.setPort(this.jobProperties.getPort());
        xxlJobSpringExecutor.setAccessToken(this.jobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.jobProperties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(this.jobProperties.getLogRetentionDays());
        return xxlJobSpringExecutor;
    }

    @Bean
    public JobTrace xxlJobTrace() {
        return new JobTrace(this.applicationName);
    }

    @Bean
    public TenantJobAspect tenantJobAspect(TenantClientProvider tenantClientProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        return new TenantJobAspect(tenantClientProvider, tenantDataIsolateProvider);
    }
}

