package com.elitescloud.boot.xxljob;

import com.elitescloud.boot.base.AbstractLogTraceHandler;
import com.xxl.job.core.CloudtJobInterceptor;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;

/**
 * 链路日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/6
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
class JobTrace extends AbstractLogTraceHandler implements CloudtJobInterceptor {

    public JobTrace(String traceIdPrefix) {
        super(traceIdPrefix);
    }

    @Override
    public boolean preExecute(@NotBlank String executorHandler, @Nullable String executorParams, int executorTimeout) {
        super.putTraceId();
        return true;
    }

    @Override
    public void afterCompletion(@NotBlank String executorHandler, @Nullable String executorParams, ReturnT<String> result, @Nullable Throwable throwable) {

    }
}
