package com.elitescloud.boot.xxljob;

import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import lombok.extern.log4j.Log4j2;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import java.util.concurrent.atomic.AtomicReference;

/**
 * 任务调度的租户处理.
 * <p>
 * 所有租户都执行一次
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/6
 */
@Log4j2
@Aspect
class TenantJobAspect {
    private final TenantClientProvider tenantClientProvider;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;

    public TenantJobAspect(TenantClientProvider tenantClientProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantClientProvider = tenantClientProvider;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }

    @Pointcut("@annotation(com.xxl.job.core.handler.annotation.XxlJob)")
    private void pointCutMethod() {
    }

    @Around("pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        if (!tenantClientProvider.enabledTenant()) {
            // 没有启用租户
            log.info("租户已禁用");
            return point.proceed();
        }

        // 获取租户
        var tenant = tenantClientProvider.getCurrentTenant();
        if (tenant != null) {
            // 已设置
            return point.proceed();
        }

        // 开始执行
        AtomicReference<Object> result = new AtomicReference<>();
        tenantDataIsolateProvider.byAllTenant(() -> {
            try {
                result.set(point.proceed());
            } catch (Throwable e) {
                throw ExceptionsUtil.wrapRuntime(e);
            }
            return null;
        });
        return result.get();
    }
}
