/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.xxljob;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
class TenantJobAspect {
    private static final Logger log = LogManager.getLogger(TenantJobAspect.class);
    private final TenantClientProvider tenantClientProvider;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;

    public TenantJobAspect(TenantClientProvider tenantClientProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantClientProvider = tenantClientProvider;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }

    @Pointcut(value="@annotation(com.xxl.job.core.handler.annotation.XxlJob)")
    private void pointCutMethod() {
    }

    @Around(value="pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        if (!this.tenantClientProvider.enabledTenant()) {
            log.info("\u79df\u6237\u5df2\u7981\u7528");
            return point.proceed();
        }
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null) {
            return point.proceed();
        }
        AtomicReference result = new AtomicReference();
        this.tenantDataIsolateProvider.byAllTenant(() -> {
            try {
                result.set(point.proceed());
            }
            catch (Throwable e) {
                throw ExceptionsUtil.wrapRuntime((Throwable)e);
            }
            return null;
        });
        return result.get();
    }
}

