package com.elitescloud.boot.xxljob.config.interceptor;

import com.elitescloud.boot.context.ExecutorContextHolder;
import com.xxl.job.core.CloudtJobInterceptor;
import com.xxl.job.core.biz.model.ReturnT;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;

/**
 * 租户上下文.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/6
 */
public class XxlJobExcutorInterceptor implements CloudtJobInterceptor {

    @Override
    public boolean preExecute(@NotBlank String executorHandler, @Nullable String executorParams, int executorTimeout) {
        ExecutorContextHolder.create(ExecutorContextHolder.Source.XXL_JOB, null, false);
        return true;
    }

    @Override
    public void afterCompletion(@NotBlank String executorHandler, @Nullable String executorParams, ReturnT<String> result, @Nullable Throwable throwable) {
        ExecutorContextHolder.clear();
    }
}
