/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.xxljob.config.tenant;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.xxl.job.core.CloudtJobInterceptor;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=-2147483647)
public class XxlJobTenantInterceptor
implements CloudtJobInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.JOB_XXLJOB.getLogger(XxlJobTenantInterceptor.class);
    private static final String PARAM = "tenantCode";
    private final TenantClientProvider tenantClientProvider;

    public XxlJobTenantInterceptor(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    public boolean preExecute(@NotBlank String executorHandler, @Nullable String executorParams, int executorTimeout) {
        if (StrUtil.isBlank((CharSequence)executorParams)) {
            logger.info("xxl-job\u6267\u884c\u53c2\u6570\uff1a{}", (Object)executorParams);
            return true;
        }
        if (!this.tenantClientProvider.enabledTenant()) {
            logger.info("\u79df\u6237\u5df2\u7981\u7528");
            return true;
        }
        String tenantCode = Arrays.stream(executorParams.split("&")).map(t -> t.split("=")).filter(t -> PARAM.equalsIgnoreCase(t[0])).map(t -> t[1]).filter(StringUtils::hasText).findFirst().orElse(null);
        logger.info("xxl-job\u6267\u884c\u53c2\u6570\uff1a{}\uff0c{}", (Object)executorParams, (Object)tenantCode);
        if (StrUtil.isBlank((CharSequence)tenantCode)) {
            return true;
        }
        SysTenantDTO tenant = this.tenantClientProvider.getTenantByCode(tenantCode);
        if (tenant == null) {
            logger.error("\u79df\u6237{}\u4e0d\u5b58\u5728", (Object)tenantCode);
            return true;
        }
        TenantContextHolder.setCurrentTenant((SysTenantDTO)tenant);
        return true;
    }

    public void afterCompletion(@NotBlank String executorHandler, @Nullable String executorParams, ReturnT<String> result, @Nullable Throwable throwable) {
        TenantContextHolder.clearCurrentTenant();
    }
}

