/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.xxljob.config.tenant;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.xxljob.common.XxlJobContext;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

@Aspect
public class TenantJobAspect {
    private static final Logger logger = CloudtBootLoggerFactory.JOB_XXLJOB.getLogger(TenantJobAspect.class);
    private final TenantClientProvider tenantClientProvider;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;

    public TenantJobAspect(TenantClientProvider tenantClientProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantClientProvider = tenantClientProvider;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }

    @Pointcut(value="@annotation(com.xxl.job.core.handler.annotation.XxlJob)")
    private void pointCutMethod() {
    }

    @Around(value="pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        logger.info("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)this.getMethodName(point));
        if (!this.tenantClientProvider.enabledTenant() || this.tenantClientProvider.getCurrentTenant() != null) {
            return point.proceed();
        }
        if (this.isRequiredNoTenant()) {
            return point.proceed();
        }
        AtomicReference result = new AtomicReference();
        this.tenantDataIsolateProvider.byAllTenant(() -> {
            try {
                result.set(point.proceed());
            }
            catch (Throwable e) {
                throw ExceptionsUtil.wrapRuntime((Throwable)e);
            }
            return null;
        });
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01");
        return result.get();
    }

    private boolean isRequiredNoTenant() {
        XxlJobContext context = XxlJobContext.getXxlJobContext();
        if (context == null) {
            return false;
        }
        String jobParams = context.getJobParam();
        if (CharSequenceUtil.isBlank((CharSequence)jobParams)) {
            return false;
        }
        String tenantCode = Arrays.stream(jobParams.split("&")).map(t -> t.split("=")).filter(t -> "tenantCode".equalsIgnoreCase(t[0])).map(t -> t[1]).filter(StringUtils::hasText).findFirst().orElse(null);
        return "-1".equals(tenantCode);
    }

    private String getMethodName(ProceedingJoinPoint point) {
        Signature methodSignature = point.getSignature();
        return methodSignature == null ? null : methodSignature.getName();
    }
}

