package com.elitescloud.cloudt.context.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * 系统工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/9
 */
public abstract class SystemUtil {

    /**
     * 获取当前地址
     *
     * @return 网卡地址
     */
    public static InetAddress getCurrentAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!inetAddress.isLinkLocalAddress() && !inetAddress.isLoopbackAddress() && inetAddress instanceof Inet4Address) {
                        return inetAddress;
                    }
                }
            }

            return InetAddress.getLocalHost();
        } catch (Exception e) {
            throw new IllegalStateException("解析IP异常", e);
        }
    }
}
