/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.condition.support;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.condition.support.AbstractCondition;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnTenantCondition
extends AbstractCondition {
    private static String CONFIG_PREFIX = "elitesland.tenant.client";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnTenant.class.getName());
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        if (this.existsAttribute(attributes, "enabled", "true")) {
            boolean enabled;
            boolean bl = enabled = this.isPresent("com.elitescloud.boot.tenant.client.common.TenantClient", null) && this.existsEnvironment(context, CONFIG_PREFIX + ".enabled", "true", "true");
            if (enabled) {
                if (this.matchIsolateStrategy(context, attributes)) {
                    return ConditionOutcome.match();
                }
                return ConditionOutcome.noMatch((String)"\u79df\u6237\u7684\u9694\u79bb\u7b56\u7565\u4e0d\u6ee1\u8db3");
            }
        }
        return ConditionOutcome.noMatch((String)"\u672a\u542f\u7528\u79df\u6237");
    }

    private boolean matchIsolateStrategy(ConditionContext context, Map<String, Object> attributes) {
        TenantIsolateStrategy[] strategies = (TenantIsolateStrategy[])attributes.getOrDefault("isolateStrategy", new TenantIsolateStrategy[0]);
        if (strategies.length == 0) {
            return true;
        }
        String strategy = context.getEnvironment().getProperty(CONFIG_PREFIX + ".isolate-strategy", TenantIsolateStrategy.NONE.name());
        for (TenantIsolateStrategy tenantIsolateStrategy : strategies) {
            if (!tenantIsolateStrategy.name().equals(strategy)) continue;
            return true;
        }
        return false;
    }
}

