package com.elitescloud.boot.support;

import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 自定义拦截器父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/27
 */
public interface CloudtInterceptor extends AsyncHandlerInterceptor {

    /**
     * 默认顺序
     *
     * @return
     */
    default int order() {
        return 0;
    }

    /**
     * 匹配拦截的路径
     *
     * @return 默认拦截所有
     */
    default String pathPatterns() {
        return "/**";
    }

    /**
     * 静态资源
     * <p>
     * 可过滤掉的
     *
     * @return
     */
    static Set<String> staticResourcePatter() {
        Set<String> excludePath = new HashSet<>();

        // swagger
        excludePath.add("/doc.html");
        excludePath.add("/doc/index.html");
        excludePath.add("/webjars/**");
        excludePath.add("/swagger-resources");
        excludePath.add("/*/api-docs");

        return excludePath;
    }

    /**
     * 转换至RequestMatcher
     *
     * @param uris
     * @return
     */
    static List<PathPattern> convert2RequestMatcher(Collection<String> uris) {
        return uris.stream()
                .map(PathPatternParser.defaultInstance::parse)
                .collect(Collectors.toList());
    }
}
