/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth;

import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;

public class AuthorizedClient
implements Serializable {
    private static final long serialVersionUID = -2450603428618865616L;
    private String clientId;
    private List<String> scopes;

    public static AuthorizedClient buildByJwt(Jwt jwt) {
        AuthorizedClient authorizedClient = new AuthorizedClient();
        List audience = jwt.getAudience();
        if (!CollectionUtils.isEmpty((Collection)audience)) {
            authorizedClient.setClientId((String)audience.get(0));
        }
        List scopes = jwt.getClaimAsStringList("scope");
        authorizedClient.setScopes((List)ObjectUtil.defaultIfNull((Object)scopes, Collections.emptyList()));
        return authorizedClient;
    }

    private void setClientId(String clientId) {
        this.clientId = clientId;
    }

    private void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }
}

