package com.elitescloud.boot.util;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import org.springframework.util.StringUtils;

/**
 * 异常工具类.
 *
 * @author Kaiser（wang shao）
 * @date 3/1/2023
 */
public class ExceptionsUtil extends ExceptionUtil {
    private ExceptionsUtil() {
    }

    /**
     * 转换异常
     *
     * @param throwable  异常
     * @param defaultMsg 默认异常信息
     * @return 异常
     */
    public static RuntimeException normalize(Throwable throwable, String defaultMsg) {
        var exp = getCausedBy(throwable, BusinessException.class, IllegalArgumentException.class);
        if (exp != null) {
            return (RuntimeException) exp;
        }
        return new BusinessException(defaultMsg);
    }

    /**
     * 获取失败原因
     *
     * @param throwable 异常
     * @return 失败原因
     */
    public static String getCauseMsg(Throwable throwable, String... defaultMsg) {
        String msg = ObjectUtil.defaultIfNull(getRootCause(throwable), throwable).getMessage();
        if (StringUtils.hasText(msg)) {
            return msg;
        }

        return defaultMsg != null && defaultMsg.length > 0 ? defaultMsg[0] : null;
    }
}
