package com.elitescloud.boot;

import com.elitescloud.boot.support.AbstractEnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 默认环境变量配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
class DefaultEnvironmentConfig extends AbstractEnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        Map<String, Object> defaultProperties = new HashMap<>(8);
        // 默认允许循环依赖
        defaultProperties.put("spring.main.allow-circular-references", true);
        // 允许bean重复定义
        defaultProperties.put("spring.main.allow-bean-definition-overriding", true);
        // 默认禁用springboot提供的flyway自动化配置，使用我们的自动化配置 {@link flyway.com.elitescloud.cloudt.context.FlywayCloudtAutoConfiguration}
        defaultProperties.put("spring.flyway.enabled", false);
        // 取消springcloud stream对function类的自动注册为provider
        defaultProperties.put("spring.cloud.stream.function.autodetect", false);
        // beanSearch 逻辑分组表达式的最大长度（字符数）
        defaultProperties.put("bean-searcher.params.group.max-expr-length", 2000);

        return defaultProperties;
    }
}
