package com.elitescloud.boot.support.app;

import com.elitescloud.boot.util.NetUtil;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * cloudt上下文容器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/29
 */
public class CloudtAppHolder {

    /**
     * 应用编码
     */
    private static String appCode = "unknown";
    /**
     * 应用名称
     */
    private static String appName = "系统";

    /**
     * 服务器实例标识
     */
    private static final String SERVER_INSTANCE;

    /**
     * 服务器ID
     */
    private static final String SERVER_IP;

    static {
        SERVER_IP = NetUtil.currentIp();
        SERVER_INSTANCE = SERVER_IP + "." + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
    }

    /**
     * 获取应用编码
     *
     * @return 应用编码
     */
    public static String getAppCode() {
        return appCode;
    }

    static void setAppCode(String appCode) {
        if (!StringUtils.hasText(appCode)) {
            return;
        }
        CloudtAppHolder.appCode = appCode;
    }

    /**
     * 获取应用名称
     *
     * @return 应用名称
     */
    public static String getAppName() {
        return appName;
    }

    static void setAppName(String appName) {
        if (!StringUtils.hasText(appName)) {
            return;
        }
        CloudtAppHolder.appName = appName;
    }

    /**
     * 获取服务实例名称
     *
     * @return 服务实例名称
     */
    public static String getServerInstance() {
        return getAppCode() + "." + SERVER_INSTANCE;
    }

    /**
     * 获取服务IP
     *
     * @return 服务IP
     */
    public static String getServerIp() {
        return SERVER_IP;
    }
}
