/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.context;

import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.util.Assert;

public class TenantContextHolder {
    private static boolean enabledTenant;
    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT;

    private TenantContextHolder() {
    }

    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull((Object)tenant, (String)"\u5f53\u524d\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a");
        CURRENT_TENANT.set(tenant);
    }

    public static void clearCurrentTenant() {
        CURRENT_TENANT.remove();
    }

    public static boolean isEnabledTenant() {
        return enabledTenant;
    }

    static void setEnabledTenant(boolean enabledTenant) {
        TenantContextHolder.enabledTenant = enabledTenant;
    }

    static {
        CURRENT_TENANT = new ThreadLocal();
    }
}

