/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JSONUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JSONUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();

    public static String toJsonString(Object obj) {
        return JSONUtil.toJsonString(obj, false);
    }

    public static String toJsonString(Object obj, boolean safely) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isPrimitive()) {
            return obj.toString();
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            if (safely) {
                throw new IllegalArgumentException("\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            }
            LOG.error("\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static <T> T json2Obj(String json, Class<T> clazz) {
        return JSONUtil.json2Obj(json, clazz, false);
    }

    public static <T> T json2Obj(String json, Class<T> clazz, boolean safely) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            if (safely) {
                throw new IllegalArgumentException("JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38\uff1a", e);
            }
            LOG.error("json\u5b57\u7b26\u4e32\u3010{}\u3011\u8f6c\u5bf9\u8c61\u5f02\u5e38:{}", (Object)json, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T json2Obj(String json) {
        return JSONUtil.json2Obj(json, false);
    }

    public static <T> T json2Obj(String json, boolean safely) {
        if (!StringUtils.hasText((String)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, new TypeReference<T>(){});
        }
        catch (JsonProcessingException e) {
            if (safely) {
                throw new IllegalArgumentException("JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5f02\u5e38\uff1a", e);
            }
            LOG.error("json\u5b57\u7b26\u4e32\u3010{}\u3011\u8f6c\u5bf9\u8c61\u5f02\u5e38:{}", (Object)json, (Object)e.getMessage());
            return null;
        }
    }
}

