/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.util.StringUtils;

public class ValidateUtil {
    private static final Validator VALIDATOR_FAST = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();
    private static final Validator VALIDATOR_ALL = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();
    public static final Pattern PATTERN_IP = Pattern.compile("((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}");
    public static final Pattern PATTERN_MOBILE = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}");
    public static final Pattern PATTERN_EMAIL = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    public static final Pattern PATTERN_PHONE = Pattern.compile("(010|02\\d|0[3-9]\\d{2})-?(\\d{6,8})");

    private ValidateUtil() {
    }

    public static <T> Set<ConstraintViolation<T>> validateObject(T pojo, boolean fast) {
        return VALIDATOR_FAST.validate(pojo, new Class[0]);
    }

    public static boolean isMobile(String mobile) {
        return StringUtils.hasText((String)mobile) && PATTERN_MOBILE.matcher(mobile).matches();
    }

    public static boolean isEmail(String email) {
        return StringUtils.hasText((String)email) && PATTERN_EMAIL.matcher(email).matches();
    }

    public static boolean isPhone(String phone) {
        return StringUtils.hasText((String)phone) && PATTERN_PHONE.matcher(phone).matches();
    }

    public static boolean isIp(String ip) {
        return StringUtils.hasText((String)ip) && PATTERN_IP.matcher(ip).matches();
    }
}

