package com.elitescloud.boot.provider;

import javax.validation.constraints.NotNull;
import java.util.function.Supplier;

/**
 * 租户组织数据隔离工具.
 * <p>
 * 配置不使用租户组织的优先级最高，其次使用传递的租户组织，最后使用当前用户的租户组织
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/4
 */
public interface TenantOrgDataIsolateProvider {

    /**
     * 不使用租户组织隔离
     *
     * @param supplier 操作
     * @param <T>      结果类型
     * @return 结果
     */
    <T> T byNoTenantOrg(@NotNull Supplier<T> supplier);

    /**
     * 使用当前租户组织隔离
     *
     * @param supplier 操作
     * @param <T>      结果类型
     * @return 结果
     */
    <T> T byCurrentTenantOrg(@NotNull Supplier<T> supplier);

    /**
     * 使用指定租户组织隔离
     *
     * @param supplier    操作
     * @param tenantOrgId 租户组织ID
     * @param <T>         结果类型
     * @return 结果
     */
    <T> T byTenantOrg(@NotNull Supplier<T> supplier, @NotNull Long tenantOrgId);
}
