/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot;

import com.elitescloud.boot.CloudtContextProperties;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.support.app.CloudtAppConfig;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.context.util.DatetimeUtil;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.support.TaskUtils;

@Import(value={JacksonConfiguration.class, AsyncConfiguration.class, CloudtAppConfig.class})
@EnableConfigurationProperties(value={CloudtContextProperties.class})
@Order(value=-2147483648)
class CloudtContextAutoConfiguration
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LogManager.getLogger(CloudtContextAutoConfiguration.class);
    @Autowired
    private SimpleApplicationEventMulticaster applicationEventMulticaster;

    CloudtContextAutoConfiguration() {
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.onApplicationContext(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        this.applicationEventMulticaster.setErrorHandler(TaskUtils.LOG_AND_SUPPRESS_ERROR_HANDLER);
    }

    private void onApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.setApplicationContext(applicationContext);
    }

    @EnableAsync
    static class AsyncConfiguration
    implements AsyncConfigurer {
        private static final Logger log = LogManager.getLogger(AsyncConfiguration.class);
        private final TaskExecutor taskExecutor;

        public AsyncConfiguration(TaskExecutor taskExecutor) {
            this.taskExecutor = taskExecutor;
        }

        public Executor getAsyncExecutor() {
            return this.taskExecutor;
        }

        public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
            return (ex, method, params) -> log.error("\u5f02\u6b65\u7ebf\u7a0b\u3010" + method.getDeclaringClass().getName() + "." + method.getName() + "\u3011\u6267\u884c\u5f02\u5e38\uff1a", ex);
        }
    }

    static class JacksonConfiguration {
        JacksonConfiguration() {
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
            return ObjectMapperFactory::builderInstance;
        }

        @Bean
        public LocalDateTimeSerializer localDateTimeSerializer() {
            return new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME);
        }

        @Bean
        public LocalDateTimeDeserializer localDateTimeDeserializer() {
            return new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME);
        }
    }
}

