/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.useragent.Browser;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.context.util.ValidateUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.server.PathContainer;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class HttpServletUtil {
    private static final Logger log = LogManager.getLogger(HttpServletUtil.class);
    private static final Map<Class<?>, Object> SHARED_OBJECTS = new HashMap();
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    public static final String PROTOCOL_HTTPS = "https://";
    public static final String PROTOCOL_HTTP = "http://";

    private HttpServletUtil() {
    }

    public static String currentClientIp() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static HttpServletRequest currentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String obtainDomain(@NotNull HttpServletRequest request) {
        String ip = HttpServletUtil.obtainDomain(request.getRequestURL().toString());
        if (!ValidateUtil.isIp(ip)) {
            return ip;
        }
        String domain = request.getHeader("Host");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain.split(":")[0])) {
            return domain;
        }
        domain = request.getHeader("Referer");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain = HttpServletUtil.obtainDomain(domain))) {
            return domain;
        }
        domain = request.getHeader("Origin");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain = HttpServletUtil.obtainDomain(domain))) {
            return domain;
        }
        return ip;
    }

    public static String obtainDomain(@NotBlank String url) {
        boolean isHttpProtocol = false;
        if (url.startsWith(PROTOCOL_HTTP)) {
            url = url.substring(7);
            isHttpProtocol = true;
        } else if (url.startsWith(PROTOCOL_HTTPS)) {
            url = url.substring(8);
            isHttpProtocol = true;
        }
        if (!isHttpProtocol) {
            return null;
        }
        int lastIndex = url.indexOf("/");
        if (lastIndex > 0) {
            url = url.substring(0, lastIndex);
        }
        if ((lastIndex = url.indexOf(":")) > 0) {
            url = url.substring(0, lastIndex);
        }
        return url;
    }

    public static MultiValueMap<String, String> getParameters(@NotNull HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> HttpServletUtil.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static MultiValueMap<String, String> getQueryParameters(@NotNull HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (!StringUtils.hasText((String)queryString)) {
            return new LinkedMultiValueMap(0);
        }
        String[] parameterArray = queryString.split("&");
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterArray.length);
        for (String s : parameterArray) {
            if (!StringUtils.hasText((String)s)) continue;
            String[] params = s.split("=");
            parameters.add((Object)params[0], params.length == 2 ? params[1] : null);
        }
        return parameters;
    }

    public static MultiValueMap<String, String> getFormParameters(@NotNull HttpServletRequest request) {
        MultiValueMap<String, String> queryParams = HttpServletUtil.getQueryParameters(request);
        if (queryParams.isEmpty()) {
            return HttpServletUtil.getParameters(request);
        }
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> HttpServletUtil.lambda$getFormParameters$1(queryParams, (MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static boolean isMultipartContent(@NotNull ServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static MultiValueMap<String, String> getHeaders(@NotNull HttpServletRequest request) {
        LinkedMultiValueMap headerMap = new LinkedMultiValueMap(64);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headerMap.add((Object)name, (Object)((String)values.nextElement()));
            }
        }
        return headerMap;
    }

    public static String getBrowser(@NotNull HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (CharSequenceUtil.isBlank((CharSequence)userAgent)) {
            return null;
        }
        try {
            UserAgent agent = UserAgentUtil.parse((String)userAgent);
            return agent == null ? null : agent.getBrowser().getName();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790user-agent\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static void writeJson(@NotNull HttpServletResponse response, @NotNull Object object) throws Exception {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        if (object instanceof String) {
            writer.write((String)object);
        } else {
            writer.write(HttpServletUtil.getObjectMapper().writeValueAsString(object));
        }
        writer.flush();
        writer.close();
    }

    public static void writeJsonIgnoreException(@NotNull HttpServletResponse response, @NotNull Object object) {
        try {
            HttpServletUtil.writeJson(response, object);
        }
        catch (Exception e) {
            log.info("\u8fd4\u56de\u524d\u7aef\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static boolean isMatch(@NotNull HttpServletRequest request, @NotBlank String pattern) {
        String uri = request.getRequestURI();
        PathPattern pathPattern = PathPatternParser.defaultInstance.parse(pattern);
        return pathPattern.matches(PathContainer.parsePath((String)uri));
    }

    public static boolean isMatchByAntPath(@NotNull HttpServletRequest request, @NotBlank String pattern) {
        String uri = request.getRequestURI();
        return ANT_PATH_MATCHER.match(pattern, uri);
    }

    private static ObjectMapper getObjectMapper() {
        Class<ObjectMapper> clazz = ObjectMapper.class;
        ObjectMapper objectMapper = HttpServletUtil.getSharedObject(clazz);
        if (objectMapper != null) {
            return objectMapper;
        }
        objectMapper = SpringContextHolder.getBean(clazz);
        HttpServletUtil.setSharedObject(clazz, objectMapper);
        return objectMapper;
    }

    private static <C> C getSharedObject(Class<C> clazz) {
        return (C)SHARED_OBJECTS.get(clazz);
    }

    private static <C> void setSharedObject(Class<C> clazz, C object) {
        SHARED_OBJECTS.put(clazz, object);
    }

    private static /* synthetic */ void lambda$getFormParameters$1(MultiValueMap queryParams, MultiValueMap parameters, String key, String[] values) {
        if (queryParams.containsKey((Object)key)) {
            return;
        }
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        } else {
            parameters.add((Object)key, null);
        }
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        } else {
            parameters.add((Object)key, null);
        }
    }

    static {
        Browser.addCustomBrowser((String)"Postman", (String)"PostmanRuntime", (String)"PostmanRuntime[\\/ ]([\\d\\w\\.\\-]+)");
    }
}

