package com.elitescloud.boot;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 云梯context属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/11
 */
@ConfigurationProperties(prefix = CloudtContextProperties.CONFIG_PREFIX)
public class CloudtContextProperties {
    public static final String CONFIG_PREFIX = "elitesland.context";

    /**
     * 服务器地址
     * 外部可访问的，如http://cloudt.elitescloud.com
     */
    private String serverAddr;

    /**
     * 系统名称
     */
    private String serverName;

    public String getServerAddr() {
        if (serverAddr != null && serverAddr.endsWith("/")) {
            return serverAddr.substring(0, serverAddr.length() - 1);
        }
        return serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}
