package com.elitescloud.boot.context;

import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.util.Assert;

/**
 * 租户上下文信息工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/26
 */
public class TenantContextHolder {

    /**
     * 是否启用了租户
     */
    private static boolean enabledTenant;

    private TenantContextHolder() {
    }

    /**
     * 租户上下文
     */
    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT = new ThreadLocal<>();

    /**
     * 获取当前租户信息
     *
     * @return 租户信息
     */
    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    /**
     * 设置当前租户信息
     *
     * @param tenant 租户信息
     */
    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull(tenant, "当前租户信息为空");
        CURRENT_TENANT.set(tenant);
    }

    /**
     * 清除当前租户信息
     */
    public static void clearCurrentTenant() {
        CURRENT_TENANT.remove();
    }

    /**
     * 是否启用了租户
     *
     * @return 是否启用了租户
     */
    public static boolean isEnabledTenant() {
        return enabledTenant;
    }

    /**
     * 设置是否启用租户
     *
     * @param enabledTenant 启用租户
     */
    static void setEnabledTenant(boolean enabledTenant) {
        TenantContextHolder.enabledTenant = enabledTenant;
    }
}
