package com.elitescloud.cloudt.context.util;

import cn.hutool.core.util.ObjectUtil;
import org.springframework.util.ClassUtils;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * 资源工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/9
 */
public class ResourceUtil {
    private ResourceUtil() {
    }

    /**
     * 加载所有资源
     *
     * @param name        资源名称
     * @param classLoader classLoader
     * @return 资源路径
     */
    public static List<URL> loadResource(@NotBlank String name, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ObjectUtil.defaultIfNull(ClassUtils.getDefaultClassLoader(), ResourceUtil.class.getClassLoader());
        }

        List<URL> urlList = new ArrayList<>(128);
        try {
            Enumeration<URL> urls = classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                urlList.add(url);
            }
        } catch (IOException e) {
            throw new IllegalArgumentException("加载资源" + name + "异常", e);
        }
        return urlList;
    }
}
