package com.elitescloud.cloudt.system.vo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author Michael Li
 */
@Data
@Accessors(chain = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserDTO implements Serializable {

    private static final long serialVersionUID = -307368107814607072L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 公司编码
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 用户姓氏
     */
    private String lastName;

    /**
     * 用户名称
     */
    private String firstName;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 微信openid
     */
    private String wxOpenid;

    /**
     * 账号来源
     * {@link UserSourceType}
     */
    private String sourceType;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否需要重置密码
     */
    private Boolean needReset;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 角色编码
     */
    private Set<String> roleCodes = Collections.emptySet();

    /**
     * 角色ID
     */
    private Set<Long> roleIds = Collections.emptySet();

    /**
     * 角色信息
     */
    private List<IdCodeNameParam> roles = Collections.emptyList();

    /**
     * 用户头像地址
     */
    private String avatarUrl;

    /**
     * 用户头像的文件编码
     */
    private String avatarCode;

    /**
     * 用户的终端
     */
    private List<Terminal> terminals = Collections.emptyList();

    /**
     * 用户所有的租户
     */
    private List<SysTenantDTO> sysTenantDTOList = Collections.emptyList();

    /**
     * 用户当前的租户
     */
    private SysTenantDTO sysTenantVO;

    /**
     * 所在组织的列表
     */
    private List<SysOrgBasicDTO> orgList;

    /**
     * 当前组织
     */
    private SysOrgBasicDTO org;

    /**
     * 所属租户组织
     */
    private SysOrgBasicDTO tenantOrg;

    /**
     * 租户组织管理员ID
     */
    private Long tenantOrgAdminId;

    public Long getTenantId() {
        if (sysTenantVO != null) {
            return sysTenantVO.getId();
        }
        return tenantId;
    }

    /**
     * 获取租户组织ID
     *
     * @return 租户组织ID
     */
    public Long getTenantOrgId() {
        if (tenantOrg == null) {
            return null;
        }
        return tenantOrg.getId();
    }

    /**
     * 获取姓名
     *
     * @return 姓名
     */
    public String getPrettyName() {
        StringBuilder result = new StringBuilder();
        if (getLastName() != null) {
            result.append(getLastName());
        }
        if (getFirstName() != null) {
            result.append(getFirstName());
        }

        return result.toString();
    }
}
