package com.elitescloud.boot.common.constant;

import org.springframework.util.MimeType;

/**
 * MimeType常量.
 * <p>
 * 参考 {@link org.springframework.http.MediaType} 和 {@link org.springframework.util.MimeTypeUtils}
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public interface MimeTypeConstant {

    MimeType XLS = new MimeType("application", "vnd.ms-exce");
    MimeType XLSX = new MimeType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    MimeType DOC = new MimeType("application", "msword");
    MimeType DOCX = new MimeType("application", "vnd.openxmlformats-officedocument.wordprocessingml.document");
    MimeType PPT = new MimeType("application", "vnd.ms-powerpoint");
    MimeType PPTX = new MimeType("application", "vnd.openxmlformats-officedocument.presentationml.presentation");
    MimeType ZIP = new MimeType("application", "zip");
    MimeType EXE = new MimeType("application", "x-msdownload");
    MimeType SQL = new MimeType("application", "x-sql");
}
