package com.elitescloud.boot.util;

import cn.hutool.core.util.ObjectUtil;

import javax.validation.constraints.NotNull;
import java.util.function.Consumer;

/**
 * 对象工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/28
 */
public class ObjUtil extends ObjectUtil {
    private ObjUtil() {
    }

    /**
     * 如果值不为空时消费
     *
     * @param value    值
     * @param consumer 消费者
     */
    public static <T> void ifNotNull(T value, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            return;
        }
        if (value != null) {
            consumer.accept(value);
        }
    }
}
