package com.elitescloud.boot;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * bootstrap配置项.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/1
 */
@ConfigurationProperties(prefix = CloudtBootstrapProperties.CONFIG_PREFIX)
public class CloudtBootstrapProperties {
    public static final String CONFIG_PREFIX = "elitesland.bootstrap";

    /**
     * 配置项
     */
    @NestedConfigurationProperty
    private Config config = new Config();

    public Config getConfig() {
        return config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config {
        /**
         * 加解密类
         */
        private String encryptor;

        public String getEncryptor() {
            return encryptor;
        }

        public void setEncryptor(String encryptor) {
            this.encryptor = encryptor;
        }
    }
}
