/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.support;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

public final class CloudtStarterTool {
    private static String CONFIG_PREFIX_TENANT = "elitesland.tenant.client";

    private CloudtStarterTool() {
    }

    public static boolean enabledTenant() {
        return CloudtStarterTool.isPresentClass("com.elitescloud.boot.tenant.client.common.TenantClient", null);
    }

    public static boolean enabledTenant(@NotNull Environment environment) {
        if (!CloudtStarterTool.enabledTenant()) {
            return false;
        }
        return CloudtStarterTool.isPresentEnvironment(environment, CONFIG_PREFIX_TENANT + ".enabled", "true", "true");
    }

    public static boolean isPresentClass(@NotBlank String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isPresentEnvironment(@NonNull Environment environment, @NonNull String key, String defaultValue, String expectValue) {
        String val = environment.getProperty(key, defaultValue);
        if (expectValue == null) {
            return val != null;
        }
        return val != null && val.toString().equals(expectValue);
    }
}

