package com.elitescloud.boot.auth;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

/**
 * 通用身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/3
 */
public class CommonAuthenticationToken extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -6308293490207800048L;

    private final Authentication original;
    private final GeneralUserDetails userDetails;
    private AuthorizedClient authorizedClient;

    public CommonAuthenticationToken(Authentication original, GeneralUserDetails userDetails, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.original = original;
        this.userDetails = userDetails;

        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return original == null ? null : original.getCredentials();
    }

    @Override
    public Object getPrincipal() {
        if (userDetails != null) {
            return userDetails;
        }
        return original.getPrincipal();
    }

    public Authentication getOriginal() {
        return original;
    }

    public GeneralUserDetails getUserDetails() {
        return userDetails;
    }

    public AuthorizedClient getAuthorizedClient() {
        return authorizedClient;
    }

    public void setAuthorizedClient(AuthorizedClient authorizedClient) {
        this.authorizedClient = authorizedClient;
    }
}
