package com.elitescloud.boot.provider;

import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.util.function.Supplier;

/**
 * 租户数据隔离工具.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/11
 */
public interface TenantDataIsolateProvider {

    /**
     * 不使用租户隔离
     * <p>
     * <font color='red'><b>适应场景有限，仅对隔离方式为schema、field时有效</b></font>
     *
     * @param executor 业务操作
     * @param <T>      数据类型
     * @return 数据
     */
    <T> T byNone(Supplier<T> executor);

    /**
     * 直接使用默认的租户
     *
     * @param executor 业务操作
     * @param <T>      数据类型
     * @return 数据
     */
    @SuppressWarnings("unchecked")
    <T> T byDefaultDirectly(Supplier<T> executor);

    /**
     * 直接使用指定的租户
     *
     * @param executor 业务操作
     * @param <T>      数据类型
     * @return 数据
     */
    @SuppressWarnings("unchecked")
    <T> T byTenantDirectly(Supplier<T> executor, SysTenantDTO tenantDTO);

    /**
     * 根据租户用户隔离的策略
     * <p>
     * 该策略下租户下的用户（除租户管理员）使用租户自己的schema，其他用户使用默认的schema
     *
     * @param executor    业务操作
     * @param currentUser 当前用户
     * @param <T>         数据类型
     * @return 数据
     */
    @SuppressWarnings("unchecked")
    <T> T byTenantUser(Supplier<T> executor, SysUserDTO currentUser);

    /**
     * 根据租户隔离的策略
     * <p>
     * 该策略下租户管理员及其用户使用租户自己的schema，其他用户使用默认的schema
     *
     * @param executor    业务操作
     * @param currentUser 当前用户
     * @param <T>         数据类型
     * @return 数据
     */
    @SuppressWarnings("unchecked")
    <T> T byTenant(Supplier<T> executor, SysUserDTO currentUser);

    /**
     * 根据租户隔离的策略
     * <p>
     * 该策略下租户管理员及其用户使用租户自己的schema，其他用户使用默认的schema，
     * 根据当前上下文获取租户
     *
     * @param executor 业务操作
     * @param <T>      数据类型
     * @return 数据
     */
    @SuppressWarnings("unchecked")
    <T> T byTenantAuto(Supplier<T> executor);

    /**
     * 处理所有租户
     *
     * @param executor 业务逻辑
     * @param <T>      数据类型
     */
    <T> void byAllTenant(Supplier<T> executor);
}
