package com.elitescloud.boot.provider;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;

import javax.validation.constraints.NotBlank;

/**
 * 当前用户提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/31
 */
public interface UserDetailProvider {

    /**
     * * 获取当前用户信息
     *
     * @return 当前用户信息
     */
    GeneralUserDetails currentUser();

    /**
     * 根据token获取
     *
     * @param token token
     * @return 用户信息
     */
    GeneralUserDetails getByToken(@NotBlank String token);
}
