/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import cn.hutool.core.text.CharSequenceUtil;
import org.springframework.util.StringUtils;

public class DesensitizeUtil {
    private DesensitizeUtil() {
    }

    public static String password(String password) {
        if (!StringUtils.hasText((String)password)) {
            return password;
        }
        return "******";
    }

    public static String mobile(String mobile) {
        if (!StringUtils.hasText((String)mobile) || mobile.length() < 8) {
            return DesensitizeUtil.username(mobile);
        }
        return CharSequenceUtil.hide((CharSequence)mobile, (int)3, (int)(mobile.length() - 4));
    }

    public static String phone(String phone) {
        if (!StringUtils.hasText((String)phone) || phone.length() < 7) {
            return DesensitizeUtil.username(phone);
        }
        return CharSequenceUtil.hide((CharSequence)phone, (int)4, (int)(phone.length() - 2));
    }

    public static String email(String email) {
        if (!StringUtils.hasText((String)email) || email.length() < 2) {
            return email;
        }
        int index = email.indexOf("@");
        if (index <= 1) {
            return email;
        }
        int startIndex = email.substring(0, index).length() > 3 ? 3 : 1;
        return CharSequenceUtil.hide((CharSequence)email, (int)startIndex, (int)index);
    }

    public static String username(String name) {
        if (!StringUtils.hasText((String)name)) {
            return name;
        }
        int len = name.length();
        if (len == 1) {
            return name;
        }
        if (len == 2) {
            return name.charAt(0) + "*";
        }
        return CharSequenceUtil.hide((CharSequence)name, (int)1, (int)(len - 1));
    }

    public static String userId(Object userId) {
        if (userId == null) {
            return "";
        }
        return "***";
    }

    public static String idCard(String idCard) {
        if (!StringUtils.hasText((String)idCard) || idCard.length() < 8) {
            return DesensitizeUtil.username(idCard);
        }
        return CharSequenceUtil.hide((CharSequence)idCard, (int)3, (int)(idCard.length() - 4));
    }

    public static String bankCard(String bankCard) {
        if (!StringUtils.hasText((String)bankCard) || bankCard.length() < 9) {
            return DesensitizeUtil.username(bankCard);
        }
        return CharSequenceUtil.hide((CharSequence)bankCard, (int)4, (int)(bankCard.length() - 4));
    }
}

