/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot;

import com.elitescloud.boot.support.AbstractEnvironmentPostProcessor;
import com.elitescloud.boot.util.CloudtBootUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

@Order(value=-2147483648)
class DefaultEnvironmentConfig
extends AbstractEnvironmentPostProcessor {
    DefaultEnvironmentConfig() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            DefaultEnvironmentConfig.addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>(8);
        defaultProperties.put("cloudt-boot.version", CloudtBootUtil.getVersion());
        defaultProperties.put("spring.main.allow-circular-references", true);
        defaultProperties.put("spring.main.allow-bean-definition-overriding", true);
        defaultProperties.put("spring.flyway.enabled", false);
        defaultProperties.put("spring.cloud.stream.function.autodetect", false);
        defaultProperties.put("bean-searcher.params.group.max-expr-length", 2000);
        return defaultProperties;
    }
}

