package com.elitescloud.cloudt.context.util;

import com.elitescloud.boot.SpringContextHolder;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.NonNull;

import java.util.Locale;

/**
 * 国际化信息工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/3
 */
public class MessageSourceUtil {

    private static MessageSource messageSource;

    private MessageSourceUtil() {
    }

    /**
     * 获取信息
     *
     * @param code 信息编码
     * @param args 参数
     * @return 信息
     */
    public static String getMessage(@NonNull String code, Object... args) {
        return getMessage(code, null, null, args);
    }

    /**
     * 获取信息
     *
     * @param code           信息编码
     * @param defaultMessage 默认信息
     * @param args           参数
     * @return 信息
     */
    public static String getMessage(@NonNull String code, String defaultMessage, Object... args) {
        return getMessage(code, defaultMessage, null, args);
    }

    /**
     * 获取信息
     *
     * @param code           信息编码
     * @param defaultMessage 默认信息
     * @param locale         方言
     * @param args           参数
     * @return 信息
     */
    public static String getMessage(@NonNull String code, String defaultMessage, Locale locale, Object... args) {
        var source = getMessageSource();

        if (locale == null) {
            // 从上下文中获取
            locale = LocaleContextHolder.getLocale();
        }

        return source.getMessage(code, args, defaultMessage, locale);
    }

    private static MessageSource getMessageSource() {
        if (messageSource == null) {
            messageSource = SpringContextHolder.getBean(MessageSource.class);
        }
        return messageSource;
    }
}
