package com.elitescloud.boot.support;

import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.core.SpringProperties;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 自定义消息转换.
 * <p>
 * xml转换器会影响到OpenFeign、RestTemplate调用，而我们不需要使用，所以忽略掉
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/18
 */
public class CloudtHttpMessagesConverters extends HttpMessageConverters {

    private static final boolean SHOULD_IGNORE_XML = SpringProperties.getFlag("spring.xml.ignore");

    public CloudtHttpMessagesConverters(HttpMessageConverter<?>... additionalConverters) {
        super(additionalConverters);
    }

    public CloudtHttpMessagesConverters(Collection<HttpMessageConverter<?>> additionalConverters) {
        super(additionalConverters);
    }

    public CloudtHttpMessagesConverters(boolean addDefaultConverters, Collection<HttpMessageConverter<?>> converters) {
        super(addDefaultConverters, converters);
    }

    @Override
    protected List<HttpMessageConverter<?>> postProcessConverters(List<HttpMessageConverter<?>> converters) {
        if (!SHOULD_IGNORE_XML) {
            return super.postProcessConverters(converters);
        }

        // 过滤掉xml的转换器
        List<HttpMessageConverter<?>> converterList = new ArrayList<>(converters.size());
        for (HttpMessageConverter<?> converter : converters) {
            if (converter instanceof MappingJackson2XmlHttpMessageConverter) {
                continue;
            }
            converterList.add(converter);
        }
        return converterList;
    }
}
